package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;

import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Pago;

import java.util.ArrayList;

public class PagoController {

    private final DatabaseHelper databaseHelper;

    private final String NOMBRE_TABLA = "pagos";

    public PagoController(Context contexto) {
        databaseHelper = new DatabaseHelper(contexto);
    }

    public void truncate() {
        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        db.execSQL("DELETE FROM " + NOMBRE_TABLA);
        Log.d("TRUNCATE", NOMBRE_TABLA);
    }

    public int eliminar(Pago pago) {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        //String[] argumentos = {String.valueOf(pago.getPrestamo_id()), String.valueOf(pago.getSemana())};
        String delete;
        if(pago.getSemana().equals("")){
            delete = "DELETE FROM " + NOMBRE_TABLA + " WHERE id in " +
                    "(SELECT id FROM " + NOMBRE_TABLA + " WHERE prestamo_id = " + pago.getPrestamo_id() + " LIMIT 1)";

        }
        else{
            delete = "DELETE FROM " + NOMBRE_TABLA + " WHERE id in " +
                    "(SELECT id FROM " + NOMBRE_TABLA + " WHERE prestamo_id = " + pago.getPrestamo_id() + " semana = " +
                    pago.getSemana() +
                    " LIMIT 1)";
        }
        db.execSQL(delete);
        return 1;
    }

    public int eliminar(String prestamo_id, String semana){

        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String delete = "DELETE FROM " + NOMBRE_TABLA + " WHERE prestamo_id = " + prestamo_id + " and semana = '" + semana+"'";

        db.execSQL(delete);
        return 1;
    }

    public long nueva(Pago pago) {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        ContentValues valoresParaInsertar = new ContentValues();
        valoresParaInsertar.put("prestamo_id", pago.getPrestamo_id());
        valoresParaInsertar.put("cantidad_esperada_pago", pago.getCantidad_esperada_pago());
        valoresParaInsertar.put("cantidad_normal_pagada", pago.getCantidad_normal_pagada());
        valoresParaInsertar.put("cantidad_multa", pago.getCantidad_multa());
        valoresParaInsertar.put("cantidad_pendiente", pago.getCantidad_pendiente());
        valoresParaInsertar.put("cantidad_total_pagada", pago.getCantidad_total_pagada());
        valoresParaInsertar.put("concepto", pago.getConcepto());
        valoresParaInsertar.put("fecha_pago", pago.getFecha_pago());
        valoresParaInsertar.put("fecha_pago_realizada", pago.getFecha_pago_realizada());
        valoresParaInsertar.put("folio", pago.getFolio());
        valoresParaInsertar.put("semana", pago.getSemana());
        valoresParaInsertar.put("balance", pago.getBalance());
        valoresParaInsertar.put("empleado_id", pago.getEmpleado_id());
        valoresParaInsertar.put("status", pago.getStatus());
        valoresParaInsertar.put("updated_at", pago.getUpdated_at());
        valoresParaInsertar.put("tipo_pago", pago.getTipo_pago());
        valoresParaInsertar.put("recuperado", pago.getRecuperado());

        return db.insert(NOMBRE_TABLA, null, valoresParaInsertar);
    }

    public ArrayList<Pago> obtener() {

        ArrayList<Pago> pagos = new ArrayList<>();
        SQLiteDatabase db = databaseHelper.getReadableDatabase();

        String query = "SELECT * FROM pagos";
        Cursor cursor = db.rawQuery(query, null);

        if (cursor == null) {

            return pagos;

        }
        if (!cursor.moveToFirst()) return pagos;

        do {

            String id = cursor.getString(0);
            String prestamo_id = cursor.getString(1);
            String cantidad_esperada_pago = cursor.getString(2);
            String cantidad_normal_pagada  = cursor.getString(3);
            String cantidad_multa = cursor.getString(4);
            String cantidad_pendiente = cursor.getString(5);
            String cantidad_total_pagada = cursor.getString(6);
            String concepto = cursor.getString(7);
            String fecha_pago = cursor.getString(8);
            String fecha_pago_realizada = cursor.getString(9);
            String folio = cursor.getString(10);
            String semana = cursor.getString(11);
            String balance = cursor.getString(12);
            String empleado_id = cursor.getString(13);
            String status = cursor.getString(14);
            String updated_at = cursor.getString(15);
            String tipo_pago = cursor.getString(16);
            String recuperado = cursor.getString(17);
            String sinc = cursor.getString(18);

            Pago pagoObtenidoDeBD = new Pago(id, prestamo_id, cantidad_esperada_pago, cantidad_normal_pagada, cantidad_multa, cantidad_pendiente,
                    cantidad_total_pagada, concepto, fecha_pago, fecha_pago_realizada, folio, semana, balance, empleado_id,status,updated_at,tipo_pago, recuperado
                    , sinc);

            pagos.add(pagoObtenidoDeBD);

        } while (cursor.moveToNext());

        cursor.close();
        return pagos;
    }
}
